access.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>
#include	<errno.h>

access(file, mode)
char *file;
{
	register unsigned short i;
	struct finfo f;

	if (_getfinfo(file, &f))
		return(-1);
	switch(mode) {
	case 0:
		return(0);
	case 1:
		if ((i=f.storage_type) == 0x0d || i == 0x0f) {
			if ((f.access&0xc3) == 0xc3)
				return(0);
		}
		else if ((i=f.file_type) == 0x06 || i == 0xf8 || i == 0xff)
			return(0);
		errno = EACCES;
		return(-1);
	case 2:
		if (f.access & 0x02)
			return(0);
		errno = EACCES;
		return(-1);
	case 4:
		if (f.access & 0x01)
			return(0);
		errno = EACCES;
		return(-1);
	}
	errno = EACCES;
	return(-1);
}

brk.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */
#include	<errno.h>

#define NULL 0

extern char *_Top;
extern unsigned short _Stksiz;

brk(ptr)
register void *ptr;
{
	register void *tmp;

	if (ptr > *((char **) 2) - _Stksiz) {
		errno = ENOMEM;
		return(-1);
	}
	_Top = ptr;
	return(0);
}

casecvt.c
/*	Copyright (C) 1985 by Manx Software Systems	*/

toupper(c)
register int c;
{
	if (c >= 'a' && c <= 'z')
		return(c - 'a' + 'A');
	return(c);
}

tolower(c)
register int c;
{
	if (c >= 'A' && c <= 'Z')
		return(c - 'A' + 'a');
	return(c);
}

close.c
/* Copyright (C) 1985 by Manx Software Systems */

#include	<prodos.h>
#include	<errno.h>
#include	<sysfunc.h>

close (fd)
{
	register struct _fil_buf *fb;
	register int err;

	if (fd >= MAXFILES || (fb = _fil_tab+fd)->unit == 0) {
		errno = EBADF;
		return(-1);
	}
	_sys_parm[0] = 1;
	_sys_parm[1] = err = fb->unit;
	fb->unit = 0;
	if ((err&0x80) == 0) {
		if (err=_system(SYS_CLOSE)) {
			errno = err;
			return(-1);
		}
	}
	return(0);
}

crt0.a65
*:ts=8
*
* Copyright (C) 1982,83,84,85 by Manx Software Systems, Inc.
*

	instxt	<zpage.h>

	global	_Top_,2
	global	_mbot_,2

	dseg
	public	MEMRY
MEMRY	rmb	2
	public	_Stksiz_
_Stksiz_
	fdb	$0800		;default stack size is 2K
	public	_End_
_End_
	fdb	$0001		;force into inited data space

	cseg
	public	_Uorg_,_Uend_,_Corg_

	public	.begin
	entry	.begin
.begin	cld
	lda	#>_Corg_
	cmp	#$20		;check system load address
	bne	notsys
	lda	#$fe
	ldx	#$be		;just below system global page
	bne	put
notsys	lda	$E000		;check basic type
	cmp	#$20		;is it integer?
	bne	chkap		;no, check applesoft
	lda	$4C		;get integer HIMEM
	ldx	$4D
	bne	put
chkap	lda	$73		;get applesoft HIMEM
	ldx	$74
put	sta	SP		;save in stack pointer
	sta	_End_
	stx	SP+1
	stx	_End_+1
	lda	#<_Uorg_	;clear out bss space
	sta	VAL
	lda	#>_Uorg_
	sta	VAL+1
	ldy	#0
loop	tya
	sta	(VAL),Y
	inc	VAL
	bne	skip
	inc	VAL+1
skip	lda	VAL
	cmp	#<_Uend_
	bne	loop
	lda	VAL+1
	cmp	#>_Uend_
	bne	loop
	lda	MEMRY		;set end of program for alloc routines
	sta	_Top_
	sta	_mbot_
	lda	MEMRY+1
	sta	_Top_+1
	sta	_mbot_+1
	lda	#<acc		;init pointers for floating point registers
	sta	ACC
	lda	#>acc
	sta	ACC+1
	lda	#<sec
	sta	SEC
	lda	#>sec
	sta	SEC+1
	jmp	_main_#

	dseg
	global	acc,14		;space reserved for floating point registers
	global	sec,14
*
data.c
/*	Copyright (C) 1985 by Manx Software Systems, Inc. */

#include	<prodos.h>

struct _fil_buf _filtab[MAXFILES] = {
	0xc0, RDWRT, 0,		/* stdin	*/
	0xc0, RDWRT, 0,		/* stdout	*/
	0xc0, RDWRT, 0		/* stderr	*/
};

exec.c
/*	Copyright (C) 1985 by Manx Software Systems, Inc. */
#include	<prodos.h>
#include	<sgtty.h>
#include	<device.h>

#define INITLEN 64

extern struct shvar {
	char			vects[6];
	int				retflg;
	char *			env;
	int				envlen;
	int				envmax;
	char *			argstk;
	unsigned char	flags;
	char			shdir[32];
	char			batch_file[32];
	unsigned short	batch_pos;
	struct _fil_buf fil_tab[MAXFILES];
	struct _dev_info dev_info;
	char			ibuf[INITLEN];  /* space for slot init strings */
	char *			iobbase;	/* ptr to base of iobs */
	struct args *	batch_args; /* base of batch args */
} *_Sp;

execl(file, arg0)
char *file, *arg0;
{
	return(execv(file, &arg0));
}

execv(arg, argv)
register char *arg, **argv;
{
	register char **p;
	register char *cp;
	register unsigned short i, argc;
	register int *ap;
	register int j;
	unsigned short mch_env;
	unsigned int iobspace;
	int (*func)();

	if (_Sp == 0)
		return(-1);
	strcpy(0x280, arg);
	ctop(0x280);

	mch_env = (unsigned short) _Sp;
	iobspace = mch_env - (unsigned short) _Sp->iobbase;
	cp = (char *)mch_env - 8;
	for (argc=0,p=argv;*p;argc++,p++)
		cp -= strlen(*p) + 1;;
	p = (char **) (cp - ((argc+1) * sizeof(char *)));
	ap = (int *)(p - 3);
	ap[0] = 0;
	ap[1] = argc;
	*((char **)(ap+2)) = (char *)p - iobspace;
	for (i=0;i<argc;i++) {
		strcpy(cp, *argv++);
		*p++ = cp - iobspace;
		cp += strlen(cp) + 1;
	}
	*p++ = 0;
	_Sp->argstk = (char *)ap;

	*(int *)0x73 = mch_env - iobspace-8;
	*(int *)0x4c = mch_env - iobspace-8;
	*(int *)0x3f2 = mch_env;
	*(char *)0x3f4 = (mch_env>>8) ^ 0xa5;

	for (i=0;i<MAXFILES;i++)
		if (((j=_fil_tab[i].unit) == 0 || (j&0x80)) &&
									_fil_tab[i].iob < _Sp->iobbase)
			_fil_tab[i].iob = 0;
	func = (char *) (mch_env + 3);
	return((*func)());
}

execp.c
#include	<prodos.h>
#include	<errno.h>

execlp(file, arg0)
char *file, *arg0;
{
	return(execvp(file, &arg0));
}

execvp(file, argv)
char *file, **argv;
{
	register char *cp, *tp;
	register int i;
	struct finfo f;
	char buf[128];
	char pbuf[128];
	char *getenv(), *index();

	tp = pbuf;
	*tp = 0;

	if (*file == '/') {		/* don't use path	*/
		strcpy(buf, file);
		goto skip;
	}

	if (cp = getenv("PATH"))		/* get the path	*/
		strcpy(pbuf, cp);
	else {
		*tp = ':';
		tp[1] = 0;
	}
	cp = pbuf;
	while (*cp) {
		tp = index(cp, ':');
		if (tp == 0)
			tp = cp + strlen(cp);
		i = tp - cp;
		strncpy(buf, cp, i);			/* construct a path name */
		buf[i] = 0;
		if (i && buf[i-1] != '/')
			strcat(buf, "/");
		strcat(buf, file);
skip:
		if (_getfinfo(buf, &f) == 0) {
			if ((i=f.file_type) == 0xff || i == 0xf8 || i == 0x06) {
				return(execv(buf, argv));
			}
		}
		cp = tp;
		if (*cp)
			cp++;
	}
	errno = ENOENT;
	return(-1);
}

exit.c
/*	Copyright (C) 1985 by Manx Software Systems, Inc. */

#include	<prodos.h>

static
noper()
{
	return(0);
}

int (*cls_)() = noper;

exit(n)
int n;
{
	register unsigned i;

	(*cls_)();
	for (i=0;i<MAXFILES;i++)
		if (_fil_tab[i].unit)
			close(i);     /* close all remaining "unbuffered" streams */
	_exit(n);
}

exitu.c
/*	Copyright (C) 1985 by Manx Software Systems, Inc. */

#include	<prodos.h>
#include	<sysfunc.h>

extern struct shvar {
	char			vects[6];
	int				retflg;
} *_Sp;

_exit(n)
{
	_sys_parm[0] = 1;
	_sys_parm[1] = 0;				/* close all files */
	_system(SYS_CLOSE);
	if (_Sp)						/* if called from SHELL */
		_Sp->retflg = n;
	(*((void (*)())0x03d0))();		/* ProDOS warm boot */
}

fixnam.a65
;:ts=8
	public	fixnam_
fixnam_
	jmp	_fixnam_
	public	_fixnam_

fixnamu.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<errno.h>

_fixnam(was, buf)
register char *was, *buf;
{
	register char *cp, *from, *ep;
	char *index();

	cp = buf;
	if (*was != '/') {
		getprefix(buf);
		strcat(buf, "/");
	}
	else
		*buf = 0;
	strcat(buf, was);
	from = buf;
	for (;;) {
		while (*from == '/')
			from++;
		*cp++ = '/';
		if (ep = index(from, '/'))
			*ep = 0;
		else {
			if (*from == '.' && (from[1] == 0 ||
										(from[1] == '.' && from[2] == 0)))
				goto skip;
			strcpy(cp, from);
			cp += strlen(cp);
			break;
		}

skip:
		if (strcmp(from, "..") == 0) {
			if (cp == buf+1) {
				errno = EINVAL;
				return(-1);
			}
			--cp;
			while (--cp > buf && *cp != '/')
				;
		}
		else if (strcmp(from, ".") == 0)
			--cp;
		else {
			cp--;
			while (*++cp = *from++)
				;
		}
		if (ep == 0)
			break;
		*ep++ = '/';
		from = ep;
	}
	if (cp == buf)
		*cp++ = '/';
	*cp = 0;
	return(0);
}

getenv.c
/*	Copyright (C) 1985 by Manx Software Systems, Inc. */

extern struct shvar {
	char	vects[6];
	int		retflg;
	char *	env;
	int		envlen;
	int		envmax;
} *_Sp;

char *
getenv(name)
char *name;
{
	register int i;
	register char *cp, *ep;
	static char *buf;
	char *index(), *malloc();

	if (_Sp == 0)
		return(0);
	cp = _Sp->env;
	i = strlen(name);
	while (*cp) {
		if (cp[i] == '=' && strncmp(cp, name, i) == 0) {
			cp += i + 1;
			if (buf)
				free(buf);
			buf = malloc(strlen(cp)+1);
			if (buf)
				strcpy(buf, cp);
			return(buf);
		}
		cp += strlen(cp) + 1;
	}
	return((char *)0);
}

geteof.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<errno.h>
#include	<prodos.h>
#include	<sysfunc.h>

struct seek_parms {
	char	param_cnt,
			ref_num;
	long	pos;				/* only lower three bytes are significant */
} ;
#define seek  ((struct seek_parms *)_sys_parm)

long
get_eof(fd)
register int fd;
{
	register int err;

	if (fd < 0 || fd > MAXFILES || (seek->ref_num=_fil_tab[fd].unit) == 0) {
		errno = EBADF;
		return(-1);
	}
	seek->param_cnt = 2;
	if (err=_system(SYS_GTEOF)) {
		errno = err;
		return(-1);
	}
	_sys_parm[5] = 0;
	return(seek->pos);
}

getfinfo.a65
;:ts=8
	public	getfinfo_
getfinfo_
	jmp	_getfinfo_
	public	_getfinfo_
getfinfu.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>
#include	<sysfunc.h>
#include	<errno.h>

_getfinfo(nam, fp)
register char *nam;
struct finfo *fp;
{
	register int err;
	char name[128];

	if (_fixnam(nam, name))
		return(-1);
	*_sys_parm = 10;
	ctop(name);
	*(char **)(_sys_parm + 1) = name;
	if ((err = _system(SYS_GINFO)) == 0)
		*fp = *(struct finfo *)(_sys_parm + 3);
	if (err) {
		errno = err;
		return(-1);
	}
	return(0);
} 

getiob.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>
#include	<errno.h>

#define NULL 0

char *
_get_iob(fd)
{
	register int i, j;
	register char *cp;
	char *sbrk();

	if ((cp=_fil_tab[fd].iob) != 0)
found:
		return(_fil_tab[fd].iob = cp);
	for (i=0;i<MAXFILES;i++) {
		if (((j=_fil_tab[i].unit) == 0 || (j&0x80)) && (cp=_fil_tab[i].iob)) {
			_fil_tab[i].iob = 0;
			goto found;
		}
	}
	cp = sbrk(0);
	if (sbrk((((unsigned short)cp + 0x4ff)&0xff00)-cp) != -1) {
		cp = (char *)(((unsigned short)cp+0xff) & 0xff00);
		goto found;
	}
	errno = ENOMEM;
	return NULL;
}

getprfx.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>
#include	<sysfunc.h>
#include	<errno.h>

getprefix(buf)
char *buf;
{
	register int err;

	*_sys_parm = 1;
	*(char **)(_sys_parm + 1) = buf;
	if ((err = _system(SYS_GTPFX)) == 0)
		ptoc(buf);
	if (err) {
		errno = err;
		return(-1);
	}
	return(0);
}

isatty.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>

isatty(fd)
register int fd;
{
	register unsigned i;

	if (fd < 0 || fd > MAXFILES || ((i = _fil_tab[fd].unit) & 0x80) == 0)
		return 0;
	return ((i&0x40) != 0);
}

lseek.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<errno.h>
#include	<prodos.h>
#include	<sysfunc.h>

struct seek_parms {
	char	param_cnt,
			ref_num;
	long	pos;				/* only lower three bytes are significant */
} ;
#define seek  ((struct seek_parms *)_sys_parm)

long
lseek (fd, pos, how)
long pos;
{
	register int err;

	if (fd < 0 || fd > MAXFILES || (seek->ref_num=_fil_tab[fd].unit) == 0) {
		err = EBADF;
xerr:
		errno = err;
		return(-1);
	}
	seek->param_cnt = 2;
	switch (how)  {
	case 0:
		seek->pos = pos;
		break;
	case 1:
		if (err = _system(SYS_GTMRK))
			goto xerr;
		seek->pos += pos;
		break;
	case 2:
		if (err=_system(SYS_GTEOF))
			goto xerr;
		seek->pos += pos;
		break;
	}

	if (err=_system(SYS_STMRK))
		goto xerr;
	_sys_parm[5] = 0;
	return(seek->pos);
}

mkdir.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>
#include	<errno.h>
#include	<sysfunc.h>

mkdir(uname)
char *uname;
{
	register int err;
	char name[64];
	

	strcpy(name, uname);
	ctop(name);
	*_sys_parm = 7;
	*(char **)(_sys_parm + 1) = name;
	*(_sys_parm + 3) = 0xc1;	/* enable everything but write */
	*(_sys_parm + 4) = 0x0f;	/* type directory file */
	*(int *)(_sys_parm + 5) = 0x0100;
	*(_sys_parm + 7) = 0x0d;		/* directory, not file */
	*(long *)(_sys_parm + 8) = 0;
	if (err = _system(SYS_CREAT)) {
		errno = err;
		return(-1);
	}
	return(0);
}

open.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<fcntl.h>
#include	<prodos.h>
#include	<errno.h>
#include	<sysfunc.h>
#include	<sgtty.h>
#include	<device.h>

creat(name, mode)
char *name;
{
	return open(name, O_WRONLY|O_TRUNC|O_CREAT, mode);
}

open(uname, flags, mode)
char *uname;
{
	register int dev, err, fd;
	register struct _fil_buf *fb;
	register char *iobuf;
	register struct _name_dev *dp;
	int mflg = 0;
	char name[64];
	struct finfo f;
	char *_get_iob();
	
	for (fb=_fil_tab;fb<_fil_tab+MAXFILES;fb++)
		if (fb->unit == 0)
			goto found;
	errno = EMFILE;
	return(-1);
found:
	fb->flags = flags & 0x03;
	fd = fb - _fil_tab;

	for (dp=&_dev_info->dev_con;dp<=&_dev_info->dev_ser;dp++) {
		if (strequ(uname, dp->dev_nam) == 0) {
			dev = dp->dev_num;
			goto gotdev;
		}
	}
	if (uname[3] == 0 && uname[2] == ':' && toupper(uname[0]) == 'S') {
		dev = uname[1] - '0';
gotdev:
		if ((dev&0x40) == 0)
			_slot_open(&_dev_info->slots[dev&7]);
		fb->unit = dev | 0x80;
		return(fd);
	}

	if ((iobuf = _get_iob(fd)) == 0)
		return -1;

	if (_fixnam(uname, name))
		return(-1);
	ctop(name);
again:
	*_sys_parm = 3;
	*(char **)(_sys_parm + 1) = name;
	*(char **)(_sys_parm + 3) = iobuf;
	if (err = _system(SYS_OPEN)) {
		if (err != 0x44 && err != 0x46) {
	xerr:
			errno = err;
			return(-1);
		}
		if ((flags&O_CREAT) == 0) {
			err = ENOENT;
			goto xerr;
		}

		*_sys_parm = 7;
		*(char **)(_sys_parm + 1) = name;
		*(_sys_parm + 3) = 0xc3;	/* enable everything */
		*(_sys_parm + 4) = 4;		/* text type file */
		*(int *)(_sys_parm + 5) = 0;
		*(_sys_parm + 7) = 1;		/* file, not directory */
		*(long *)(_sys_parm + 8) = 0;
		if (err = _system(SYS_CREAT))
			goto xerr;
		flags &= ~(O_EXCL|O_CREAT|O_TRUNC);
		mflg = 1;
		goto again;
	}

	fb->unit = _sys_parm[5];
	if ((flags&(O_CREAT|O_EXCL)) == (O_CREAT|O_EXCL)) {
		close(fd);
		err = EEXIST;
		goto xerr;
	}
	if (flags & O_TRUNC)
		_seteof(fd, 0L);
	else if (flags & O_APPEND)
		lseek(fd, 0L, 2);
	if (mflg) {
		_getfinfo(uname, &f);
		f.access = mode;
		_setfinfo(uname, &f);
	}
	return(fd);
}

perror.c
#include <stdio.h>
#include <errno.h>

struct errlist {
	int code;
	char *msg;
} errlist[] = {
	0x00, "No error",
	0x01, "Invalid number for system call",
	0x04, "Invalid param count for system call",
	0x25, "Interrupt vector table full",
	0x27, "I/O Error",
	0x28, "No device connected/detected",
	0x2b, "Disk write protected",
	0x2e, "Disk switched",
	0x40, "Invalid characters in pathname",
	0x42, "File control block table full",
	0x43, "Invalid reference number",
	0x44, "Directory not found",
	0x45, "Volume not found",
	0x46, "File not found",
	0x47, "Duplicate file name",
	0x48, "Volume Full",
	0x49, "Volume directory full",
	0x4a, "Incompatible file format",
	0x4b, "Unsupported storage type",
	0x4c, "End of file encountered",
	0x4d, "Position out of range",
	0x4e, "File Access error; eg, file locked",
	0x50, "File is open",
	0x51, "Directory structure damaged",
	0x52, "Not a ProDOS disk",
	0x53, "Invalid system call parameter",
	0x55, "Volume control block table full",
	0x56, "Bad buffer address",
	0x57, "Duplicate volume",
	0x5a, "Invalid address in bit map",
	-1, "Unknown Error Code"
};

#define MAXERR 0x5a

perror (s)
char *s;
{
	register struct errlist * sp;

	if (errno < 0 || errno > MAXERR)
		return -1;
	if (s)
		fprintf (stderr, "%s: ", s);
	for (sp=errlist;sp->code>=0;sp++)
		if (sp->code == errno)
			break;
	fprintf (stderr, "%s\n", sp->msg);
	return 0;
}
read.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>
#include	<fcntl.h>
#include	<errno.h>
#include	<sysfunc.h>
#include	<sgtty.h>
#include	<device.h>

struct rd_info {
	char	param_cnt,
			ref_num;
	char	*data_buf;
	int		count,
			trans_cnt;
} ;
#define io_buf  ((struct rd_info *)_sys_parm)

read (fd, buf, cnt)
register int fd, cnt;
register char *buf;
{
	register int err;
	register struct _fil_buf *b;

	if (fd < 0 || fd >= MAXFILES || (b = _fil_tab+fd)->unit == 0 || 
														b->flags == O_WRONLY) {
		errno = EBADF;
		return(-1);
	}
	if ((b->unit)&0x80) {
		if (b->unit&0x40)
			return(_kb_get(buf, cnt));
		return(_dev_read(&_dev_info->slots[b->unit&7], buf, cnt));
	}
	io_buf->param_cnt = 4;
	io_buf->ref_num = b->unit;
	io_buf->data_buf = buf;
	io_buf->count = cnt;
	if ((err = _system(SYS_READ)) && err != 0x4c) {
		errno = err;
		return(-1);
	}
	return(io_buf->trans_cnt);
}

_dev_read(s, buf, cnt)
struct _slot_dev *s;
unsigned char *buf;
{
	int i;

	for (i=0;i<cnt;i++)
		if ((*buf++ = _slot_read(s)) < 0)
			break;
	return(i);
}

rename.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */
#include	<sysfunc.h>
#include	<errno.h>

rename(o, n)
register char *o, *n;
{
	register int err;
	char old[128], new[128];

	if (_fixnam(n, new) || _fixnam(o, old))
		return(-1);
	ctop(old);
	ctop(new);
	_sys_parm[0] = 2;
	*(char **)(_sys_parm + 1) = old;
	*(char **)(_sys_parm + 3) = new;
	err = _system(SYS_RENAM);
	if (err) {
		errno = err;
		return(-1);
	}
	return(0);
}

rsvstk.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */

extern unsigned short _Stksiz;

rsvstk(size)
{
	_Stksiz = size;
}

samain.a65
*:ts=8
*
* Copyright (c) 1982,83,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>

	global	_dev_info_,2
	global	_devinfo_,0
	global	_fil_tab_,2
	global	_filtab_,0
	global	errno_,2
	global	_Sp_,2

	public	_main_
_main_
	lda	#<_devinfo_
	sta	_dev_info_
	lda	#>_devinfo_
	sta	_dev_info_+1
	lda	#<_filtab_
	sta	_fil_tab_
	lda	#>_filtab_
	sta	_fil_tab_+1
	sec
	lda	SP
	sbc	#6
	sta	SP
	bcs	.1
	dec	SP+1
.1
	ldy	#5
	lda	#0
.2
	sta	(SP),Y
	dey
	bpl	.2
	jsr	main_
	sec			;return from main: call exit(0)
	lda	SP
	sbc	#4
	sta	SP
	bcs	drop1
	dec	SP+1
drop1
	lda	#0
	ldy	#3
loop1	
	sta	(SP),Y
	dey
	bne	loop1
	jsr	exit_
	brk
;
	public	main_
	public	exit_

cmdmain.c
#define NULL (char *) 0
#define BUFSIZ 80
static char buf[BUFSIZ];

_cmdline()
{
	register char *bp=buf;
	register int i=1;
	register int c;
	register int argc=1;
	char *argv[20];
	int cnt;

	argv[0] = "";
	write(1,"\ncmd? ",6);
	if ((cnt=read(0,buf,BUFSIZ)) <=0){
		argv[1]=NULL;
		return main(argc, argv);
	}
	buf[cnt-1]=0;

	while (*bp){
		while ((c=*bp) && (c==' ' || c=='\t'))
			++bp;
		if (!*bp)
			break;
		argv[i++] = bp;
		++argc;
		while ((c=*++bp) && c != ' ' && c != '\t')
			;
		*bp++ = 0;
	}
	argv[i] = NULL;
	return main(argc, argv);
}
#asm
*:ts=8
*
* Copyright (c) 1982,83,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>

	global	_dev_info_,2
	global	_devinfo_,0
	global	_fil_tab_,2
	global	_filtab_,0
	global	errno_,2
	global	_Sp_,2

	public	_main_
_main_
	lda	#<_devinfo_
	sta	_dev_info_
	lda	#>_devinfo_
	sta	_dev_info_+1
	lda	#<_filtab_
	sta	_fil_tab_
	lda	#>_filtab_
	sta	_fil_tab_+1
	sec
	lda	SP
	sbc	#6
	sta	SP
	bcs	.1x
	dec	SP+1
.1x
	ldy	#5
	lda	#0
.2x
	sta	(SP),Y
	dey
	bpl	.2x
	jsr	_cmdline_
	ldy	#0
	tya
	sta	(SP),Y
	iny
	sta	(SP),Y
	jsr	exit_
	brk
;
	public	main_
	public	exit_

#endasm
sbrk.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */
#include	<errno.h>

#define NULL 0

extern char *_Top, *_End;
extern unsigned short _Stksiz;

char *
sbrk(size)
register unsigned size;
{
	register char *tmp;

	if (_Top+size > _End-_Stksiz || (((long)_Top+size) & 0xffff0000L)) {
		errno = ENOMEM;
		return(-1);
	}
	tmp = _Top;
	_Top += size;
	return(tmp);
}

seteof.a65
;:ts=8
	public	seteof_
seteof_
	jmp	_seteof_
	public	_seteof_
seteofu.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<errno.h>
#include	<prodos.h>
#include	<sysfunc.h>

struct seek_parms {
	char	param_cnt,
			ref_num;
	long	pos;				/* only lower three bytes are significant */
} ;
#define seek  ((struct seek_parms *)_sys_parm)

long
_seteof(fd, pos)
register int fd;
long pos;
{
	register int err;

	if (fd < 0 || fd > MAXFILES || (seek->ref_num=_fil_tab[fd].unit) == 0) {
		errno = EBADF;
		return(-1);
	}
	seek->param_cnt = 2;
	seek->pos = pos;
	if (err=_system(SYS_STEOF)) {
		errno = err;
		return (-1);
	}
	_sys_parm[5] = 0;
	return(seek->pos);
}

setfinfo.a65
;:ts=8
	public	setfinfo_
setfinfo_
	jmp	_setfinfo_
	public	_setfinfo_
setfinfu.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */
#include	<prodos.h>
#include	<sysfunc.h>
#include	<errno.h>

_setfinfo(nam, fp)
register char *nam;
struct finfo *fp;
{
	register int err;
	char name[128];

	if (_fixnam(nam, name))
		return(-1);
	_sys_parm[0] = 7;
	ctop(name);
	*(char **)(_sys_parm + 1) = name;
	*(struct finfo *)(_sys_parm + 3) = *fp;
	err = _system(SYS_SINFO);
	if (err) {
		errno = err;
		return(-1);
	}
	return(0);
}

setiob.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>
#include	<errno.h>

setiob(cnt)
{
	register int i, tally;
	register char *cp;
	char *sbrk();

	tally = 0;
	for (i=0;i<MAXFILES;i++)
		if (_fil_tab[i].iob)
			tally++;
	for (i=0;i<MAXFILES && tally < cnt;i++) {
		if (_fil_tab[i].iob || _fil_tab[i].unit)
			continue;
		cp = sbrk(0);
		sbrk((((unsigned short)cp + 0x4ff)&0xff00)-cp);
		_fil_tab[i].iob = (char *)(((unsigned short)cp+0xff) & 0xff00);
		tally++;
	}
}

setprfx.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>
#include	<sysfunc.h>
#include	<errno.h>

setprefix(buf)
register char *buf;
{
	register int err;

	_sys_parm[0] = 1;
	ctop(buf);
	*(char **)(_sys_parm + 1) = buf;
	err = _system(SYS_STPFX);
	ptoc(buf);
	if (err) {
		errno = err;
		return(-1);
	}
	return(0);
}

shmain.a65
*:ts=8
*
* Copyright (c) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>

	global	_dev_info_,2
	global	_fil_tab_,2
	global	errno_,2
	global	_Sp_,2

	public	_main_
_main_
	lda	#<$bc73
	sta	_dev_info_
	lda	#>$bc73
	sta	_dev_info_+1
	lda	#<$bc53
	sta	_fil_tab_
	lda	#>$bc53
	sta	_fil_tab_+1
	sta	_Sp_+1
	jsr	main_
	sec			;return from main: call exit(0)
	lda	SP
	sbc	#4
	sta	SP
	bcs	drop1
	dec	SP+1
drop1
	lda	#0
	ldy	#3
loop1
	sta	(SP),Y
	dey
	bne	loop1
	jsr	exit_
	brk
;
	public	main_
	public	exit_

strshft.a65
*:ts=8
*
* Copyright (C) 1984,85 by Manx Software Systems
*

	instxt	<zpage.h>

*	Convert C string to a Pascal string

	public	ctop_
ctop_
	ldy	#2
	lda	(SP),Y			;get ptr into R0
	sta	R0
	iny
	lda	(SP),Y
	sta	R0+1
	ldy	#0
*
.1
	lda	(R0),Y			;find strlen
	iny
	cmp #0
	bne .1
*
	dey
	beq .3			;len = 0
	sty	R1			;strlen
.2
	dey
	lda (R0),Y
	iny
	sta (R0),Y
	dey
	bne .2
*
	lda R1
	sta (R0),Y
.3
	rts
*
	public	ptoc_
ptoc_
	ldy	#2
	lda	(SP),Y
	sta	R0
	iny
	lda	(SP),Y
	sta	R0+1
	ldy	#0
*
	lda (R0),Y		;strlen
	beq .5
	sta R1
	ldy #0
.4
	iny
	lda	(R0),Y
	dey
	sta	(R0),Y
	iny
	cpy R1
	bne .4
	lda #0
	sta (R0),Y
.5
	rts
system.a65
*:ts=8
* Copyright (C) 1985 by Manx Software Systems, Inc.
*

	instxt	<zpage.h>

MLI	equ	$bf00

	global	_sys_parm_,18	;parameter area for ProDOS MLI calls

*
*	_system(SYSFUNC)
*

	public	_system_
_system_
	ldy	#2
	lda	(SP),Y
	sta	SYSFUNC
	jsr	MLI
SYSFUNC	fcb	0
	fdb	_sys_parm_
	sta	R0
	lda	#0
	sta	R0+1
	rts

unlink.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */
#include	<sysfunc.h>
#include	<errno.h>

unlink(nam)
register char *nam;
{
	register int err;
	char name[128];

	if (_fixnam(nam, name))
		return(-1);
	ctop(name);
	_sys_parm[0] = 1;
	*(char **)(_sys_parm + 1) = name;
	err = _system(SYS_DSTRY);
	if (err) {
		errno = err;
		return(-1);
	}
	return(0);
}

write.c
/* Copyright (C) 1984 by Manx Software Systems */
#include	<prodos.h>
#include	<fcntl.h>
#include	<errno.h>
#include	<sysfunc.h>
#include	<sgtty.h>
#include	<device.h>

struct rd_info {
	char	param_cnt,
			ref_num;
	char	*data_buf;
	int		count,
			trans_cnt;
} ;
#define io_buf  ((struct rd_info *)_sys_parm)

write (fd, buf, cnt)
register int fd, cnt;
register char *buf;
{
	register int err;
	register struct _fil_buf *b;

	if (fd < 0 || fd >= MAXFILES || (b = _fil_tab+fd)->unit == 0 || 
													b->flags == O_RDONLY) {
		errno = EBADF;
		return(-1);
	}
	if (cnt == 0)
		return(0);
	if (b->unit & 0x80) {
		if (b->unit & 0x40)
			return(_kb_put(buf, cnt));
		return(_dev_write(&_dev_info->slots[b->unit&7], buf, cnt));
	}
	io_buf->param_cnt = 4;
	io_buf->ref_num = b->unit;
	io_buf->data_buf = buf;
	io_buf->count = cnt;
	io_buf->trans_cnt = 0;
	if (err=_system(SYS_WRITE)) {
		errno = err;
		return(-1);
	}
	return(io_buf->trans_cnt);
}

_dev_write(s, buf, cnt)
char *buf;
{
	int i = cnt;

	while (cnt--)
		_slot_write(s, *buf++);
	return(i);
}

makefile
.SUFFIXES: .c .a65 .r .i

.c.r:
	cg65 +g0,8,80,10 -o $*.r $*.c
	sqz65 $*.r

.c.i:
	cci -ao $*.asm $*.c
	optint65 -ZAP $*.asm
	sqz65 $*.i

.a65.r:
	as65 -o $*.r $*.a65
	sqz65 $*.r

SRC= access.c brk.c\
	casecvt.c close.c crt0.a65 data.c exec.c execp.c exit.c exitu.c\
	fixnam.a65 fixnamu.c\
	getenv.c geteof.c getfinfo.a65 getfinfu.c  getiob.c getprfx.c\
	isatty.c lseek.c\
	mkdir.c open.c  perror.c read.c rename.c rsvstk.c\
	samain.a65 sbrk.c seteof.a65 seteofu.c \
	setfinfo.a65 setfinfu.c setiob.c setprfx.c\
	shmain.a65 strshft.a65 system.a65\
	unlink.c write.c 

REL= exitu.r fixnamu.r getfinfu.r seteofu.r setfinfu.r access.r brk.r\
	casecvt.r close.r crt0.r data.r exec.r execp.r exit.r fixnam.r\
	getenv.r geteof.r getfinfo.r getiob.r getprfx.r isatty.r lseek.r\
	mkdir.r open.r  read.r rename.r rsvstk.r samain.r sbrk.r seteof.r\
	setfinfo.r setiob.r setprfx.r shmain.r strshft.r system.r\
	unlink.r write.r perror.r cmdmain.r

INT= exitu.i fixnamu.i getfinfu.i seteofu.i setfinfu.i access.i brk.i\
	casecvt.i close.i crt0.r data.i exec.i execp.i exit.i fixnam.r\
	getenv.i geteof.i getfinfo.r getiob.i getprfx.i isatty.i lseek.i\
	mkdir.i open.i  read.i rename.i rsvstk.i samain.r sbrk.i seteof.r\
	setfinfo.r setiob.i setprfx.i shmain.r strshft.r system.r\
	unlink.i write.i perror.i cmdmain.r

rel: $(REL)
	echo done

int: $(INT)
	echo done
